-------------------------------------------------------------------------
--
--     Scripted Plugin for the Arnold 5.0 "vr_camera" node
--     = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
--
-------------------------------------------------------------------------
plugin Camera arnold_vr_camera
extends:FreeCamera
name:~ARNOLD_CAMERA_VR_NAME~
classID:#(515151,262397)
category:"Arnold"
replaceUI:true
(
	parameters main rollout:params
	(
		arnold_node type:#string default:"vr_camera"
		arnold_node_mode type:#integer default:1 ui:mode
		arnold_node_projection type:#integer default:1 ui:project
		arnold_node_eye_separation type:#worldunits default:(units.decodeValue("65mm")) ui:eyeSeparation
		arnold_node_eye_to_neck type:#worldunits default:(units.decodeValue("0mm")) ui:eyeToNeck
		
		arnold_node_top_merge_mode type:#integer default:2 ui:topMergeMode
		arnold_node_top_merge_angle type:#float default:60.0 ui:topMergeAngle

		arnold_node_bottom_merge_mode type:#integer default:2 ui:bottomMergeMode
		arnold_node_bottom_merge_angle type:#float default:60.0 ui:bottomMergeAngle
	)
  
	-- Hack to touch a parameter that the camera translator "cares" about to 
	-- trigger a retranslation. Ugly, but.... works for now :D
	fn forceUpdate = 
	(
		if delegate.fov == 160 then delegate.fov = 160.001 else delegate.fov = 160		
	)
  
	rollout params ~ARNOLD_CAMERA_VR_PARAMS~
	(
		dropdownlist mode       ~ARNOLD_CAMERA_VR_MODE~ items:#(~ARNOLD_CAMERA_VR_MODE1~, ~ARNOLD_CAMERA_VR_MODE2~, ~ARNOLD_CAMERA_VR_MODE4~, ~ARNOLD_CAMERA_VR_MODE5~)
		dropdownlist project    ~ARNOLD_CAMERA_VR_PROJ~ items:#(~ARNOLD_CAMERA_VR_PROJ1~, ~ARNOLD_CAMERA_VR_PROJ2~, ~ARNOLD_CAMERA_VR_PROJ3~)
		spinner eyeSeparation   ~ARNOLD_CAMERA_VR_INTEROCULAR~ type:#worldunits range:[0.0,10000.0,65.0]
		spinner eyeToNeck   "Eye to Neck" type:#worldunits range:[0.0,1000.0,0.0]

		dropdownlist topMergeMode ~ARNOLD_CAMERA_VR_MERGEMODE_TOP~ items:#(~ARNOLD_CAMERA_VR_MERGE_OFF~, ~ARNOLD_CAMERA_VR_MERGE_COS~)
		spinner topMergeAngle     ~ARNOLD_CAMERA_VR_MERGE_ANG~ 

		dropdownlist bottomMergeMode ~ARNOLD_CAMERA_VR_MERGEMODE_BOT~ items:#(~ARNOLD_CAMERA_VR_MERGE_OFF~, ~ARNOLD_CAMERA_VR_MERGE_COS~)
		spinner bottomMergeAngle     ~ARNOLD_CAMERA_VR_MERGE_ANG~  
	  
		-- This is a workaround for the camera being too smart, and ignoring any
		-- updates that are not in its set of "parameters I care about"
		on mode selected val do forceUpdate()
		on project selected val do forceUpdate()
		on eyeSeparation changed val do forceUpdate()
		on eyeToNeck changed val do forceUpdate()
		on topMergeMode selected val do forceUpdate()
		on topMergeAngle changed val do forceUpdate()
		on bottomMergeMode selected val do forceUpdate()	  
		on bottomMergeAngle changed val do forceUpdate()
	)
	
	tool create
	(
		on mousePoint click do
			case click of
			(
				1: nodeTM.translation = gridPoint
				2: (
					setCommandPanelTaskMode #modify					
					#stop
				)
			)
		on mouseMove click do
			if click == 2 then nodeTM.translation = gridPoint
	)

	on create do forceUpdate()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQC3vObdJ/5AFVwi+AwVBUWDC6/JChhis68p
-- NC3MGaF5CRoz00ewKyLydly1/jWNWb3ufe9LCqDEv6qYhtBKg0dMZTlGL7CmEduz
-- ZXGjMpH+c/yy9j0oVBDr0hGtYxo3rKIKNZNb8hzeAa9dgsgSNWn+jlcfa0smKLPD
-- 4FqCw1cBbsRRVULerCaRYZ8vFcs+Hk7Ug6cZZJuQEKqDXLZSLUGEBLNR0TTmJ2JB
-- pxGkd9XMvSuN/e+w6G6mdb4dffkO1KRf83p1a15bik6KmYdE+bxWgswJxCXxnq/7
-- feeCom5puhcCeFuuWo2DeOXrxLL4pHNmkb/31beiMy76Vn/da6o0
-- -----END-SIGNATURE-----